
#ifdef USE_DIRECT_OS
#include <stdio.h>
#include <memory.h>
#define SYSTEM_S_IMPORT_INTERFACE_TYPES
#include "system_pif.h"
#else
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#include "osabstraction.h"

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#include "AES.h"
#include "AES_common.h"

#include "AESReader.h"




AESReader::AESReader()
{
}

AESReader::~AESReader()
{
}

#ifndef BULLSHIT
tBool AESReader::bDecryptFile (tCString szFileName, tU32 *pu32ByteSize, tU8 **ppu8Data)
{
   tBool bSuccess = FALSE;
   if (ppu8Data != NULL && pu32ByteSize != NULL)
   {
      *ppu8Data = NULL;
      *pu32ByteSize = 0;
   
      AES oAES;
      oAES.SetParameters(256);

      FileHandle hFile = fileOpenReadOnly(szFileName);
      if (hFile != INVALID_FILE_HANDLE)
      {
         tS32 s32Size = getFileSize(hFile);

         if (s32Size >= 16 + BLOCKSIZE)
         {
            // 16 Byte sind der Overhead... soviel muss wenigstens da sein!
            *ppu8Data = new tU8[s32Size];
            tU8 *pu8Tmp = new tU8[s32Size];
            if (*ppu8Data != NULL && pu8Tmp != NULL)
            {
               if (readFile(pu8Tmp, 1, s32Size, hFile) == s32Size)
               {
                  tU32 u32MajVersion       = ((tU32 *) (pu8Tmp))[0];
                  tU32 u32MinVersion       = ((tU32 *) (pu8Tmp))[1];
                  tU32 u32KeyID            = ((tU32 *) (pu8Tmp))[2];
                  tU32 u32NumBlocksWritten = *((tU32 *) (pu8Tmp + s32Size - sizeof(tU32)*2));
                  *pu32ByteSize            = *((tU32 *) (pu8Tmp + s32Size - sizeof(tU32)));

                  tU32 u32NumDataBlocks = (s32Size - OVERHEAD) / BLOCKSIZE;
                  tU32 u32BlocksProcessed = 0;
            
                  if (     u32MajVersion == DEFAULT_FILE_VERSION_MAJOR 
                        && u32MinVersion == DEFAULT_FILE_VERSION_MINOR
                        && u32KeyID < s_u32NumKeys    )
                  {
                     oAES.StartDecryption(keys[u32KeyID]);
                     
                     if ( *pu32ByteSize < (tU32) s32Size && *pu32ByteSize > (tU32) (s32Size - OVERHEAD - BLOCKSIZE - u32NumBlocksWritten*sizeof(tU32)))
                     {
                        tU8 *pu8Read = pu8Tmp + HEADER_BYTES;
                        
                        while (u32BlocksProcessed < u32NumDataBlocks)
                        {
                           tU32 u32NumBlocks = *((tU32*)pu8Read);
                           pu8Read += sizeof (tU32);
                           
                           if (u32BlocksProcessed + u32NumBlocks <= u32NumDataBlocks)
                           {
                              oAES.Decrypt(pu8Read, *ppu8Data + u32BlocksProcessed*BLOCKSIZE, u32NumBlocks);
                              pu8Read += u32NumBlocks*BLOCKSIZE;
                              u32BlocksProcessed += u32NumBlocks;
                              bSuccess = TRUE;
                           }
                           else
                           {
                              bSuccess = FALSE;
                              break;
                           }
                        }
                     }
                  }
               }
            }

            if (pu8Tmp != NULL)
            {
               delete[] pu8Tmp;
            }
         }
         fileClose(hFile);
      }

      if (bSuccess == FALSE)
      {
         *pu32ByteSize = 0;
         if (*ppu8Data != NULL)
         {
            delete[] *ppu8Data;
            *ppu8Data = NULL;
         }
      }
   }

   return bSuccess;
}

#else


tBool AESReader::bDecryptFile (tCString szFileName, tU32 *pu32ByteSize, tU8 **ppu8Data)
{
   tBool bSuccess = FALSE;
   if (ppu8Data != NULL && pu32ByteSize != NULL)
   {
      *ppu8Data = NULL;
      *pu32ByteSize = 0;
   
      AES oAES;
      oAES.SetParameters(256);

      FILE *hFile1 = fopen (szFileName, "rb");
      OSAL_tIODescriptor hFile2 = OSAL_IOOpen (szFileName, OSAL_EN_READONLY);

      if (hFile1 != NULL || hFile2 != OSAL_ERROR)
      {
         tS32 s32Size = -1;
         if (hFile1 != NULL)
         {
            fseek(hFile1, 0, SEEK_END);
            fpos_t srcLength;
            fgetpos(hFile1, &srcLength);
            fseek(hFile1, 0, SEEK_SET);
      #if defined(WIN32) || defined(__APPLE__)
            s32Size = (tS32) srcLength;
      #else
            s32Size = (tS32) srcLength.__pos;
      #endif
         }
         else
         {
            s32Size = OSALUTIL_s32FGetSize(hFile2);
         }

         if (s32Size >= 16 + BLOCKSIZE)
         {
            // 16 Byte sind der Overhead... soviel muss wenigstens da sein!
            *ppu8Data = OSAL_NEW tU8[s32Size];
            tU8 *pu8Tmp = OSAL_NEW tU8[s32Size];
            if (*ppu8Data != NULL && pu8Tmp != NULL)
            {
               tS32 s32Tmp = -1;
               if (hFile1 != NULL)
               {
                  s32Tmp = fread(pu8Tmp, 1, s32Size, hFile1);
               }
               else
               {
                  s32Tmp = OSAL_s32IORead(hFile2, (tPS8) pu8Tmp, s32Size);
               }

               if (s32Tmp == s32Size)
               {
                  tU32 u32MajVersion       = ((tU32 *) (pu8Tmp))[0];
                  tU32 u32MinVersion       = ((tU32 *) (pu8Tmp))[1];
                  tU32 u32KeyID            = ((tU32 *) (pu8Tmp))[2];
                  tU32 u32NumBlocksWritten = *((tU32 *) (pu8Tmp + s32Size - sizeof(tU32)*2));
                  *pu32ByteSize            = *((tU32 *) (pu8Tmp + s32Size - sizeof(tU32)));

                  tU32 u32NumDataBlocks = (s32Size - OVERHEAD) / BLOCKSIZE;
                  tU32 u32BlocksProcessed = 0;
            
                  if (     u32MajVersion == DEFAULT_FILE_VERSION_MAJOR 
                        && u32MinVersion == DEFAULT_FILE_VERSION_MINOR
                        && u32KeyID < s_u32NumKeys    )
                  {
                     oAES.StartDecryption(keys[u32KeyID]);
                     
                     if ( *pu32ByteSize < (tU32) s32Size && *pu32ByteSize > (tU32) (s32Size - OVERHEAD - BLOCKSIZE - u32NumBlocksWritten*sizeof(tU32)))
                     {
                        tU8 *pu8Read = pu8Tmp + HEADER_BYTES;
                        
                        while (u32BlocksProcessed < u32NumDataBlocks)
                        {
                           tU32 u32NumBlocks = *((tU32*)pu8Read);
                           pu8Read += sizeof (tU32);
                           
                           if (u32BlocksProcessed + u32NumBlocks <= u32NumDataBlocks)
                           {
                              oAES.Decrypt(pu8Read, *ppu8Data + u32BlocksProcessed*BLOCKSIZE, u32NumBlocks);
                              pu8Read += u32NumBlocks*BLOCKSIZE;
                              u32BlocksProcessed += u32NumBlocks;
                              bSuccess = TRUE;
                           }
                           else
                           {
                              bSuccess = FALSE;
                              break;
                           }
                        }
                     }
                  }
               }
            }

            if (pu8Tmp != NULL)
            {
               OSAL_DELETE[] pu8Tmp;
            }
         }
         if (hFile1 != NULL)
            fclose(hFile1);
         else
            OSAL_s32IOClose(hFile2);
      }

      if (bSuccess == FALSE)
      {
         *pu32ByteSize = 0;
         if (*ppu8Data != NULL)
         {
            OSAL_DELETE[] *ppu8Data;
            *ppu8Data = NULL;
         }
      }
   }

   return bSuccess;
}





#endif      // BULLSHIT
